
// CapaPlay ][ Unit for C/C++

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long int dword;

/****************************** GUS Settings *********************************/

extern "C" far byte CP_GetIRQ();
extern "C" far void CP_SetIRQ(byte NewIRQ);
extern "C" far byte CP_GetDMA();
extern "C" far void CP_SetDMA(byte NewDMA);
extern "C" far word CP_GetBasePort();
extern "C" far void CP_SetBasePort(int NewBasePort);
extern "C" far void CP_SetLineIn(byte LineInState);
extern "C" far void CP_SetMicIn(byte MicInState);

/******************************* Load/Unload *********************************/

extern "C" far byte CP_LoadModule(char *ModName,dword ReadPoint,byte TransferMode);
extern "C" far byte CP_LoadPatterns(char *ModName,dword ReadPoint,byte TransferMode);
extern "C" far void CP_FreeModule();

/***************************** Start/Stop/Pause ******************************/

extern "C" far void CP_StartModule(byte Amplification,byte DefaultPanning,byte TimerMode);
extern "C" far void CP_StopModule();
extern "C" far byte CP_PauseModule();

/********************** Set General Module Information ***********************/

extern "C" far void CP_SetSpeedZeroMode(byte SpeedZeroMode);
extern "C" far void CP_SetPanEffectMode(byte PanEffectMode);
extern "C" far void CP_SetVBlankMode(byte VBlankMode);
extern "C" far void CP_SetAmigaLimitsMode(byte AmigaLimitsMode);

/********************** Get General Module Information ***********************/

extern "C" far char *CP_GetModuleName();
extern "C" far byte CP_GetModuleType();
extern "C" far byte CP_GetModuleLength();
extern "C" far word CP_GetNumOfPatterns();
extern "C" far byte CP_GetNumOfInstruments();
extern "C" far byte CP_GetNumOfChannels();
extern "C" far byte CP_GetNumOfUsedChannels();
extern "C" far byte CP_GetRestartPosition();
extern "C" far dword CP_GetUsedPatternMemory();
extern "C" far dword CP_GetUsedInstrumentInfoMemory();
extern "C" far dword CP_GetUsedGUSMemory();			       
extern "C" far dword CP_GetFileSize();

/********************** Set General Playing Information **********************/

extern "C" far void CP_SetPosition(int NewPosition);
extern "C" far void CP_SetGlobalVolume(int NewVolume);
extern "C" far void CP_SetSpeed(int NewSpeed);
extern "C" far void CP_SetTempo(int NewTempo);
extern "C" far void CP_RestoreSpeedAndTempo();
extern "C" far void CP_SetDefaultPanning(char DefaultPanning);

/********************** Get General Playing Information **********************/

extern "C" far byte CP_GetRow();
extern "C" far word CP_GetNumOfRows(int PositionNum);
extern "C" far byte CP_GetPosition();
extern "C" far byte CP_GetPattern();
extern "C" far byte CP_GetGlobalVolume();
extern "C" far byte CP_GetSpeed();
extern "C" far byte CP_GetTempo();
extern "C" far word CP_GetPlayingTime();
extern "C" far dword CP_GetTimer();
extern "C" far byte CP_GetLoopCounter();

/************************* Set Channel Information ***************************/

extern "C" far byte CP_SetChannelMute(int ChannelNum,byte MuteState);
extern "C" far void CP_SetChannelPanning(int ChannelNum,byte NewPanning);
extern "C" far byte CP_PlaySample(byte ChannelNum,int InstrumentNum,int SampleNum,byte Note,byte Octave);
extern "C" far byte CP_StopSample(byte ChannelNum);

/************************* Get Channel Information ***************************/

extern "C" far byte CP_GetChannelNote(int ChannelNum);
extern "C" far byte CP_GetChannelOctave(int ChannelNum);
extern "C" far byte CP_GetChannelVolume(int ChannelNum);
extern "C" far byte CP_GetChannelEffect(int ChannelNum);
extern "C" far byte CP_GetChannelEffectParams(int ChannelNum);
extern "C" far byte CP_GetChannelInstrument(int ChannelNum);
extern "C" far byte CP_GetChannelSample(int ChannelNum);
extern "C" far byte CP_GetChannelBar(int ChannelNum);
extern "C" far byte CP_GetChannelNoteTrigger(int ChannelNum);
extern "C" far byte CP_GetChannelPanning(int ChannelNum);
extern "C" far byte CP_GetChannelMute(int ChannelNum);

/******************** Set Instrument/Sample Information **********************/

extern "C" far byte CP_SetSampleMute(int InstrumentNum,int SampleNum,byte MuteState);

/******************** Get Instrument/Sample Information **********************/

extern "C" far char *CP_GetInstrumentName(int InstrumentNum);
extern "C" far byte CP_GetNumOfSamples(int InstrumentNum);
extern "C" far char *CP_GetSampleName(int InstrumentNum,int SampleNum);
extern "C" far dword CP_GetSampleSize(int InstrumentNum,int SampleNum);
extern "C" far word CP_GetSampleC4Spd(int InstrumentNum,int SampleNum);
extern "C" far byte CP_GetSampleVolume(int InstrumentNum,int SampleNum);
extern "C" far byte CP_GetSamplePanning(int InstrumentNum,int SampleNum);
extern "C" far byte CP_GetSampleLoopType(int InstrumentNum,int SampleNum);
extern "C" far dword CP_GetSampleLoopBegin(int InstrumentNum,int SampleNum);
extern "C" far dword CP_GetSampleLength(int InstrumentNum,int SampleNum);
extern "C" far byte CP_GetSample16Bit(int InstrumentNum,int SampleNum);
extern "C" far byte CP_GetSampleMute(int InstrumentNum,int SampleNum);

